//
//  Detecting_Panning_and_Dragging_GesturesViewController.m
//  Detecting Panning and Dragging Gestures
//
//  Created by Vandad Nahavandipoor on 15/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Detecting_Panning_and_Dragging_GesturesViewController.h"

@implementation Detecting_Panning_and_Dragging_GesturesViewController

@synthesize panGestureRecognizer;
@synthesize helloWorldLabel;

- (void)didReceiveMemoryWarning{
  [super didReceiveMemoryWarning];
}

- (void) handlePanGestures:(UIPanGestureRecognizer*)paramSender{
  
  if (paramSender.state != UIGestureRecognizerStateEnded &&
      paramSender.state != UIGestureRecognizerStateFailed){
    CGPoint location = [paramSender locationInView:paramSender.view.superview];
    paramSender.view.center = location;
  }
  
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  self.view.backgroundColor = [UIColor whiteColor];
  
  /* Najpierw tworzymy etykietę. */
  CGRect labelFrame = CGRectMake(0.0f,    /* X */
                                 0.0f,    /* Y */
                                 150.0f,  /* Szerokość. */
                                 100.0f); /* Wysokość. */
  
  self.helloWorldLabel = [[UILabel alloc] initWithFrame:labelFrame];
  self.helloWorldLabel.text = @"Witaj świecie";
  self.helloWorldLabel.backgroundColor = [UIColor blackColor];
  self.helloWorldLabel.textColor = [UIColor whiteColor];
  self.helloWorldLabel.textAlignment = UITextAlignmentCenter;
  
  /* Upewniamy się, że włączona została interakcja z użytkownikiem. W przeciwnym razie */
  /* zdarzenia naciśnięć nie będą przechwytywane dla tej etykiety. */
  self.helloWorldLabel.userInteractionEnabled = YES;
  
  /* Upewniamy się, że etykieta jest wyświetlana w widoku. */
  [self.view addSubview:self.helloWorldLabel];
  
  /* Tworzymy procedurę rozpoznawania gestu przesunięcia. */
  self.panGestureRecognizer = [[UIPanGestureRecognizer alloc] 
                               initWithTarget:self
                               action:@selector(handlePanGestures:)];
  
  /* Do aktywowania procedury gestu przesunięcia wymagany jest przynajmniej i co najwyżej jeden palec. */
  self.panGestureRecognizer.minimumNumberOfTouches = 1;
  self.panGestureRecognizer.maximumNumberOfTouches = 1;
  
  /* Add it to our view */
  [self.helloWorldLabel addGestureRecognizer:self.panGestureRecognizer];
  
}

- (void) viewDidUnload{
  [super viewDidUnload];
  self.panGestureRecognizer = nil;
  self.helloWorldLabel = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
